// test/upload.test.tsx
import React from 'react'
import { render, screen, fireEvent } from '@testing-library/react'
import UploadComponent from '@/components/upload/upload'
import '@testing-library/jest-dom'

describe('UploadComponent', () => {
  it('should render upload component correctly', () => {
    render(<UploadComponent />)

    const input = screen.getByTestId('upload-input')
    const uploadButton = screen.getByTestId('upload-button')

    expect(input).toBeInTheDocument()
    expect(uploadButton).toBeInTheDocument()
  })

  it('should update selected file on file change', () => {
    render(<UploadComponent />)

    const input = screen.getByTestId('upload-input') as HTMLInputElement
    const file = new File(['hello'], 'hello.png', { type: 'image/png' })

    fireEvent.change(input, { target: { files: [file] } })
    expect(input.files?.[0]).toEqual(file)
  })
})
