package com.g9.g9backend.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.g9.g9backend.pojo.Comment;
import com.g9.g9backend.pojo.DTO.GetCommentDTO;
import com.g9.g9backend.service.CommentService;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@RestController
@RequestMapping("/comment")
public class CommentController {

    private final CommentService commentService;

    private final Logger logger = LoggerFactory.getLogger(CommentController.class);

    public CommentController(CommentService commentService) {
        this.commentService = commentService;
    }

    @PostMapping
    public ResponseEntity<String> postComment(@RequestBody Comment comment) {
        System.out.println(comment.toString());
        commentService.save(comment);

        logger.info("评论已发布");

        return ResponseEntity.ok("");
    }

    @DeleteMapping
    public ResponseEntity<String> deleteComment(@RequestParam Integer commentId) {
        commentService.removeById(commentId);

        return ResponseEntity.noContent().build();
    }

    @GetMapping
    public ResponseEntity<GetCommentDTO> getComment(@RequestParam Integer id,
                                                    @RequestParam Integer pageNumber,
                                                    @RequestParam Integer rows,
                                                    @RequestParam String type) {
        Page<Comment> commentPage = new Page<>(pageNumber, rows);
        LambdaQueryWrapper<Comment> rewardQuery = new LambdaQueryWrapper<Comment>()
                .orderByDesc(Comment::getCreateAt);


        if (Objects.equals(type, "资源")) {

            rewardQuery.eq(Comment::getResourceId, id);
        }

        if (Objects.equals(type, "帖子")) {

            rewardQuery.eq(Comment::getThreadId, id);
        }

        if (Objects.equals(type, "悬赏")) {

            rewardQuery.eq(Comment::getRewardId, id);
        }

        Page<Comment> result = commentService.page(commentPage, rewardQuery);

        GetCommentDTO getCommentDTO = wrapCommentPage(result, item -> {
            GetCommentDTO.Comment comment = new GetCommentDTO.Comment();
            comment.setCommentId(item.getCommentId());
            comment.setUserId(item.getUserId());
            comment.setReplyId(item.getReplyId() != null ? item.getReplyId() : 0);
            comment.setContent(item.getContent());
            comment.setCreateAt(item.getCreateAt());
            return comment;
        });

        return ResponseEntity.ok(getCommentDTO);
    }

    @NotNull
    private <T> GetCommentDTO wrapCommentPage(Page<T> page, Function<T, GetCommentDTO.Comment> mapper) {
        List<GetCommentDTO.Comment> records = page.getRecords().stream().map(mapper).toList();

        return new GetCommentDTO(records, (int) page.getTotal(), (int) page.getPages(), (int) page.getCurrent(), (int) page.getSize());
    }

}
