package com.g9.g9backend.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.g9.g9backend.pojo.Notification;
import com.g9.g9backend.service.NotificationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * NotificationController 通知控制器类，处理与通知相关的请求
 *
 * @author Seamher
 */
@RestController
@RequestMapping("/notification")
public class NotificationController {

    private final NotificationService notificationService;

    public NotificationController(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    private final Logger logger = LoggerFactory.getLogger(NotificationController.class);

    @PostMapping(value = "/read")
    public ResponseEntity<String> getNotificationRead(@RequestBody Notification notification) {
        Integer notificationId = notification.getNotificationId();
        System.out.println(notificationId);
        Notification notificationUpdate = notificationService.getById(notificationId);
        notificationUpdate.setRead(true);
        notificationService.updateById(notificationUpdate);

        return ResponseEntity.ok("");
    }

    @DeleteMapping
    @ResponseStatus(HttpStatus.NO_CONTENT)
    public ResponseEntity<String> deleteNotification(@RequestParam Integer notificationId) {
        notificationService.removeById(notificationId);

        return ResponseEntity.noContent().build();
    }

    @GetMapping
    public ResponseEntity<IPage<Notification>> getNotification(@RequestParam Integer userId,
                                                               @RequestParam Integer pageNumber,
                                                               @RequestParam Integer rows) {
        Page<Notification> notificationPage = new Page<>(pageNumber, rows);
        LambdaQueryWrapper<Notification> notificationQuery = new LambdaQueryWrapper<Notification>()
                .eq(Notification::getUserId, userId)
                .orderByDesc(Notification::getCreateAt);

        IPage<Notification> result = notificationService.page(notificationPage, notificationQuery);
        logger.info("通知已返回");

        return ResponseEntity.ok(result);
    }

}
