package com.g9.g9backend.controller;

import com.g9.g9backend.service.ResourceService;
import com.g9.g9backend.service.ThreadService;
import com.g9.g9backend.service.UserPurchaseService;
import com.g9.g9backend.service.UserUploadService;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/total")
public class TotalController {

    private final ThreadService threadService;

    private final UserPurchaseService userPurchaseService;

    private final UserUploadService userUploadService;

    private final ResourceService resourceService;

    public TotalController(ThreadService threadService, UserPurchaseService userPurchaseService, UserUploadService userUploadService, ResourceService resourceService) {
        this.threadService = threadService;
        this.userPurchaseService = userPurchaseService;
        this.userUploadService = userUploadService;
        this.resourceService = resourceService;
    }

    private final Logger logger = LoggerFactory.getLogger(TotalController.class);


    @GetMapping(value = "/info")
    public ResponseEntity<Info> getTotalInfo() {

        long threadCount = threadService.count();
        long downloadCount = userPurchaseService.count();
        long authorCount = userUploadService.count();
        long resourceCount = resourceService.count();

        Info info = new Info(threadCount, downloadCount, authorCount, resourceCount);
        logger.info("统计数据返回：{}", info);

        return ResponseEntity.ok(info);
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Info {

        private long threadCount;

        private long downloadCount;

        private long authorCount;

        private long resourceCount;

    }
}
