package com.g9.g9backend.pojo.DTO;

import com.g9.g9backend.pojo.Resource;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

@Data
public class GetResourceHotSlideDTO {

    private List<ResourceSlideInfo> records;

    public GetResourceHotSlideDTO(List<Resource> resourceList) {
        List<ResourceSlideInfo> records = new ArrayList<>();
        for (Resource resource : resourceList) {
            ResourceSlideInfo resourceSlideInfo = new ResourceSlideInfo();
            resourceSlideInfo.setResourceId(resource.getResourceId());
            resourceSlideInfo.setResourceName(resource.getResourceName());
            resourceSlideInfo.setResourcePicture(resource.getResourcePicture());
            records.add(resourceSlideInfo);
        }
        this.records = records;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ResourceSlideInfo {
        private int resourceId;

        private String resourceName;

        private String resourcePicture;
    }
}
