package com.g9.g9backend.pojo.DTO;

import com.g9.g9backend.pojo.HotTrend;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.*;

@Data
public class GetResourceHotTrendDTO {

    private List<HotRecord> records;

    public GetResourceHotTrendDTO(List<HotTrend> hotTrendList) {
        List<HotRecord> records = new ArrayList<>();

        HotRecord resourcePackHotRecord = new HotRecord();
        resourcePackHotRecord.setClassify("resourcePack");
        List<HotInfo> resourceHotInfoList = new ArrayList<>();

        HotRecord modHotRecord = new HotRecord();
        modHotRecord.setClassify("mod");
        List<HotInfo> modHotInfoList = new ArrayList<>();

        HotRecord modPackHotRecord = new HotRecord();
        modPackHotRecord.setClassify("modPack");
        List<HotInfo> modPackHotInfoList = new ArrayList<>();

        HotRecord mapHotRecord = new HotRecord();
        mapHotRecord.setClassify("map");
        List<HotInfo> mapHotInfoList = new ArrayList<>();

        for (HotTrend hotTrend : hotTrendList) {
            switch (hotTrend.getClassify()) {
                case "resourcePack":
                    HotInfo resourcePackHotInfo = new HotInfo();
                    resourcePackHotInfo.setHot(hotTrend.getHot());
                    resourcePackHotInfo.setTime(hotTrend.getTime());
                    resourceHotInfoList.add(resourcePackHotInfo);
                    break;
                case "mod":
                    HotInfo modHotInfo = new HotInfo();
                    modHotInfo.setHot(hotTrend.getHot());
                    modHotInfo.setTime(hotTrend.getTime());
                    modHotInfoList.add(modHotInfo);
                    break;
                case "modPack":
                    HotInfo modPackHotInfo = new HotInfo();
                    modPackHotInfo.setHot(hotTrend.getHot());
                    modPackHotInfo.setTime(hotTrend.getTime());
                    modPackHotInfoList.add(modPackHotInfo);
                    break;
                case "map":
                    HotInfo mapHotInfo = new HotInfo();
                    mapHotInfo.setHot(hotTrend.getHot());
                    mapHotInfo.setTime(hotTrend.getTime());
                    mapHotInfoList.add(mapHotInfo);
                    break;
                default:
                    break;
            }
        }

        // 按照 Time 从早到晚排序
        resourceHotInfoList.sort(Comparator.comparing(HotInfo::getTime));
        modHotInfoList.sort(Comparator.comparing(HotInfo::getTime));
        modPackHotInfoList.sort(Comparator.comparing(HotInfo::getTime));
        mapHotInfoList.sort(Comparator.comparing(HotInfo::getTime));

        resourcePackHotRecord.setHotInfoList(resourceHotInfoList);
        modHotRecord.setHotInfoList(modHotInfoList);
        modPackHotRecord.setHotInfoList(modPackHotInfoList);
        mapHotRecord.setHotInfoList(mapHotInfoList);

        records.add(resourcePackHotRecord);
        records.add(modHotRecord);
        records.add(resourcePackHotRecord);
        records.add(mapHotRecord);

        this.records = records;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class HotRecord {
        private String classify;

        private List<HotInfo> hotInfoList;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class HotInfo {
        private float hot;

        private Date time;
    }
}
