package com.g9.g9backend.pojo.DTO;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.g9.g9backend.pojo.*;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Data
public class GetResourceInfoDTO {

    private int resourceId;

    private String resourceName;

    private String resourcePicture;

    private String resourceSummary;

    private String resourceDetail;

    private Date uploadTime;

    private Date lastUpdateTime;

    private int price;

    private int downloads;

    private int likes;

    private int collections;

    private int comments;

    private String classify;

    private float hot;

    private String[] gameplayList;

    private List<ResourceVersionInfo> resourceVersionList;

    // isCollect在序列化成JSON 时，字段会被映射为collect，所以这里显式指定 JSON 序列化时的字段名
    @JsonProperty("isCollect")
    private boolean isCollect;

    @JsonProperty("isLike")
    private boolean isLike;

    @JsonProperty("isPurchase")
    private boolean isPurchase;

    @JsonProperty("isUpload")
    private boolean isUpload;

    private int uploaderId;

    public GetResourceInfoDTO(Resource resource, List<Gameplay> gameplayList, List<ResourceVersion> resourceVersionList, List<List<GameVersion>> gameVersionLists, List<List<TorrentRecord>> torrentRecordLists, boolean isCollect, boolean isLike, boolean isPurchase, boolean isUpload, int uploaderId) {
        // 创建资源基本信息
        this.resourceId = resource.getResourceId();
        this.resourceName = resource.getResourceName();
        this.resourcePicture = resource.getResourcePicture();
        this.resourceSummary = resource.getResourceSummary();
        this.resourceDetail = resource.getResourceDetail();
        this.uploadTime = resource.getUploadTime();
        this.lastUpdateTime = resource.getLastUpdateTime();
        this.price = resource.getPrice();
        this.downloads = resource.getDownloads();
        this.likes = resource.getLikes();
        this.collections = resource.getCollections();
        this.comments = resource.getComments();
        this.classify = resource.getClassify();
        this.hot = (float) (0.25 * resource.getDownloads() + 0.25 * resource.getLikes() + 0.25 * resource.getCollections() + 0.25 * resource.getComments());
        this.isCollect = isCollect;
        this.isLike = isLike;
        this.isPurchase = isPurchase;
        this.isUpload = isUpload;
        this.uploaderId = uploaderId;

        // 创建玩法列表
        String[] gameplays = new String[gameplayList.size()];
        // 处理对应的 gameplay 列表
        for (int i = 0; i < gameplayList.size(); i++) {
            Gameplay gameplay = gameplayList.get(i);
            gameplays[i] = gameplay.getGameplayName();
        }
        this.gameplayList = gameplays;

        // 创建资源版本列表
        List<ResourceVersionInfo> resourceVersions = new ArrayList<>();
        for (int i = 0; i < resourceVersionList.size(); i++) {
            ResourceVersionInfo resourceVersionInfo = new ResourceVersionInfo();
            ResourceVersion resourceVersion = resourceVersionList.get(i);
            List<GameVersion> gameVersions = gameVersionLists.get(i);
            List<TorrentRecord> torrentRecords = torrentRecordLists.get(i);

            resourceVersionInfo.setResourceVersionId(resourceVersion.getResourceVersionId());
            resourceVersionInfo.setResourceVersionName(resourceVersion.getResourceVersionName());
            String[] compatibleVersions = new String[gameVersions.size()];
            for (int j = 0; j < gameVersions.size(); j++) {
                GameVersion gameVersion = gameVersions.get(j);
                compatibleVersions[j] = gameVersion.getGameVersionName();
            }
            resourceVersionInfo.setCompatibleVersions(compatibleVersions);
            List<TorrentRecordInfo> torrentRecordInfos = new ArrayList<>();
            for (TorrentRecord torrentRecord : torrentRecords) {
                TorrentRecordInfo torrentRecordInfo = new TorrentRecordInfo();
                torrentRecordInfo.setTorrentRecordId(torrentRecord.getTorrentRecordId());
                torrentRecordInfo.setTorrentUrl(torrentRecord.getTorrentUrl());
                torrentRecordInfo.setInfoHash(torrentRecord.getInfoHash());
                torrentRecordInfo.setUploadTime(torrentRecord.getUploadTime());
                torrentRecordInfo.setUploaderUserId(torrentRecord.getUploaderUserId());

                torrentRecordInfos.add(torrentRecordInfo);
            }
            resourceVersionInfo.setTorrentList(torrentRecordInfos);
            resourceVersionInfo.setSeeds(resourceVersion.getSeeds());

            resourceVersions.add(resourceVersionInfo);
        }
        this.resourceVersionList = resourceVersions;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ResourceVersionInfo {
        private int resourceVersionId;

        private String resourceVersionName;

        private String[] compatibleVersions;

        private List<TorrentRecordInfo> torrentList;

        private int seeds;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class TorrentRecordInfo {
        private int torrentRecordId;

        private String torrentUrl;

        private String infoHash;

        private Date uploadTime;

        private int uploaderUserId;
    }
}
