package com.g9.g9backend.pojo.DTO;

import com.g9.g9backend.pojo.Gameplay;
import com.g9.g9backend.pojo.Resource;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Data
public class GetResourcePageDTO {

    private List<ResourceInfo> records = new ArrayList<>();

    private long total;

    private long pages;

    private long current;

    private long size;

    public GetResourcePageDTO (List<Resource> resourceList, List<List<Gameplay>> gameplayLists,long total, long pages, long current, long size) {
        List<ResourceInfo> recordList = new ArrayList<>();
        // 遍历 resourceList 和 gameplayLists
        for (int i = 0; i < resourceList.size(); i++) {
            Resource resource = resourceList.get(i);
            List<Gameplay> allGameplayList = gameplayLists.get(i); // 同步访问 gameplayLists 的对应元素

            // 创建 ResourceInfo 对象
            ResourceInfo resourceInfo = new ResourceInfo();
            resourceInfo.setResourceId(resource.getResourceId());
            resourceInfo.setResourceName(resource.getResourceName());
            resourceInfo.setResourcePicture(resource.getResourcePicture());
            resourceInfo.setResourceSummary(resource.getResourceSummary());
            resourceInfo.setLastUpdateTime(resource.getLastUpdateTime());
            // 加权求和得到热度
            resourceInfo.setHot((float) (0.25 * resource.getDownloads() + 0.25 * resource.getLikes() + 0.25 * resource.getCollections() + 0.25 * resource.getComments()));
            // 创建玩法列表
            String[] gameplayList = new String[allGameplayList.size()];
            // 处理对应的 gameplay 列表
            for (int j = 0; j < allGameplayList.size(); j++) {
                Gameplay gameplay = allGameplayList.get(j);
                gameplayList[j] = gameplay.getGameplayName();
            }
            resourceInfo.setGameplayList(gameplayList);
            recordList.add(resourceInfo);
        }
        this.records = recordList;
        this.total = total;
        this.pages = pages;
        this.current = current;
        this.size = size;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ResourceInfo {
        private int resourceId;

        private String resourceName;

        private String resourcePicture;

        private String resourceSummary;

        private Date lastUpdateTime;

        private float hot;

        private String[] gameplayList;
    }
}
