package com.g9.g9backend.service;

import com.turn.ttorrent.tracker.Tracker;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TrackerService {

    private final Logger logger = LoggerFactory.getLogger(TrackerService.class);

    @PostConstruct
    public void initTracker() {
        try {
            Tracker tracker = new Tracker(6969, "http://localhost:6969/announce");
            tracker.setAcceptForeignTorrents(true);
            tracker.start(false);
            logger.info("Tracker服务器已启动，监听端口 6969");
        } catch (Exception e) {
            logger.error("Tracker启动失败：", e);
        }
    }

}
