package com.g9.g9backend.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.g9.g9backend.mapper.InvitationMapper;
import com.g9.g9backend.pojo.Invitation;
import com.g9.g9backend.service.InvitationService;
import org.springframework.stereotype.Service;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;

@Service
public class InvitationServiceImpl extends ServiceImpl<InvitationMapper, Invitation> implements InvitationService {

    private static final String CHAR_POOL = "ABCDEFGHJKLMNPQRSTUVWXYZ23456789"; // 字符池
    private static final int CODE_LENGTH = 8; // 邀请码长度
    private static final int CODE_COUNT = 5; // 邀请码数量
    private final Random random = new Random();

    @Override
    public String[] generateInvitationCode() {
        // 使用不允许存储重复的元素的数据结构：Set
        Set<String> uniqueCodes = new HashSet<>();

        // 生成 5 个互不重复的邀请码
        while (uniqueCodes.size() < CODE_COUNT) {
            String code = generateRandomCode();

            // 检查数据库中是否已存在该邀请码
            QueryWrapper<Invitation> invitationQuery = new QueryWrapper<>();
            invitationQuery.eq("invitation_code", code);
            boolean exists = this.count(invitationQuery) > 0;

            // 如果数据库中不存在，加入集合
            if (!exists) {
                uniqueCodes.add(code);
            }
        }

        // 返回字符串数组
        return uniqueCodes.toArray(new String[0]);
    }

    // 生成随机邀请码的方法
    private String generateRandomCode() {
        StringBuilder code = new StringBuilder(CODE_LENGTH);
        for (int i = 0; i < CODE_LENGTH; i++) {
            code.append(CHAR_POOL.charAt(random.nextInt(CHAR_POOL.length())));
        }
        return code.toString();
    }
}
