package com.g9.g9backend.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.g9.g9backend.pojo.*;
import com.g9.g9backend.pojo.DTO.*;
import com.g9.g9backend.service.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * UserController 用户控制器类，处理与用户相关的请求
 *
 * @author hcy
 */
@RestController
@RequestMapping("/user")
public class UserController {

    private final UserService userService;

    private final InvitationService invitationService;

    private final SubscriptionService subscriptionService;

    public UserController(UserService userService, InvitationService invitationService, SubscriptionService subscriptionService) {
        this.userService = userService;
        this.invitationService = invitationService;
        this.subscriptionService = subscriptionService;
    }

    private final Logger logger = LoggerFactory.getLogger(UserController.class);

    /**
     * 用户注册
     *
     * @param registerDTO 用户注册
     * @return 注册结果
     */
    @PostMapping("/register")
    public ResponseEntity<String> register(@RequestBody RegisterDTO registerDTO) {
        String username = registerDTO.getUsername();
        String password = registerDTO.getPassword();
        String invitationCode = registerDTO.getInvitationCode();
        logger.info("Register request received for account: {}", username);

        // 根据用户名查询该用户名是否已存在
        QueryWrapper<User> userQuery = new QueryWrapper<>();
        userQuery.eq("username", username);
        User userCheck = userService.getOne(userQuery);

        if (userCheck != null) {
            // 用户名重复
            logger.warn("Registration attempt failed. Account already exists: {}", username);
            return ResponseEntity.status(407).body("");
        }

        // 查询邀请码是否存在
        QueryWrapper<Invitation> invitationQuery = new QueryWrapper<>();
        invitationQuery.eq("invitation_code", invitationCode);
        Invitation invitation = invitationService.getOne(invitationQuery);

        if (invitation == null) {
            // 邀请码不存在
            logger.info("The invitation code does not exist: {}", invitationCode);
            return ResponseEntity.status(409).body("");
        } else if (invitation.getInviteeId() != 0) {
            // 邀请码已被使用
            logger.info("The invitation code has been used: {}", invitationCode);
            return ResponseEntity.status(410).body("");
        }
        // 注册
        // 添加新用户
        User user = new User();
        user.setUsername(username);
        user.setPassword(password);
        userService.save(user);

        // 设置该邀请码已被使用
        User userGetId = userService.getOne(userQuery);
        int newUserId = userGetId.getUserId();

        UpdateWrapper<Invitation> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("invitation_code", invitationCode).set("invitee_id", newUserId);
        invitationService.update(updateWrapper);

        // 生成五个邀请码并分配给新用户
        String[] invitationCodes = invitationService.generateInvitationCode();

        for (String code : invitationCodes) {
            Invitation newInvitation = new Invitation();
            newInvitation.setInvitationCode(code);
            newInvitation.setUserId(newUserId);
            invitationService.save(newInvitation);
        }

        logger.info("User registered successfully: {}", username);
        return ResponseEntity.ok("");
    }

    /**
     * 用户登录
     *
     * @param user 登录信息
     * @return 登录结果
     */
    @PostMapping("/login")
    public ResponseEntity<String> login(@RequestBody User user) {
        String username = user.getUsername();
        String password = user.getPassword();
        logger.info("Login attempt for account: {}", username);

        // 根据用户名查询该用户名是否已存在
        QueryWrapper<User> userQuery = new QueryWrapper<>();
        userQuery.eq("username", username);
        User userCheck = userService.getOne(userQuery);

        if (userCheck == null) {
            // 用户名不存在
            logger.warn("Login failed. User not found: {}", username);
            return ResponseEntity.status(406).body("");
        } else {
            if (userCheck.getPassword().equals(password)) {
                return ResponseEntity.ok("");
            } else {
                // 密码错误
                logger.warn("Login failed. Incorrect password for account: {}", username);
                return ResponseEntity.status(408).body("");
            }
        }
    }

    /**
     * 关注
     *
     * @param subscription 关注信息
     * @return 关注结果
     */
    @PostMapping("/subscription")
    public ResponseEntity<String> subscription(@RequestBody Subscription subscription) {
        subscriptionService.save(subscription);
        return ResponseEntity.ok("");
    }
}