package com.g9.g9backend.pojo.DTO;

import com.g9.g9backend.pojo.Invitation;
import lombok.*;

import java.util.ArrayList;
import java.util.List;

@Data
public class GetInvitationCodeDTO {

    // 调用 .add() 方法之前，确保 invitationCodeList 已经被实例化，否则会抛出空指针
    private List<InvitationCode> invitationCodeList = new ArrayList<>();

    public GetInvitationCodeDTO(List<Invitation> invitationList) {
        for (Invitation invitation : invitationList) {
            invitationCodeList.add(new InvitationCode(invitation.getInvitationCode()));
        }
    }

    // 内部类 InvitationCode
    @Data //注意没有@Data的话即没有getter、setter方法，会导致Jackson无法获取私有字段（仅对private）的值，从而无法序列化这个类
    @AllArgsConstructor
    public static class InvitationCode {
        private String invitationCode;
    }
}