package com.g9.g9backend.pojo.DTO;

import com.g9.g9backend.pojo.User;
import lombok.AllArgsConstructor;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
public class GetUserDTO {

    private List<Subscriber> userList = new ArrayList<>();

    public GetUserDTO(List<User> users) {
        for (User user : users) {
            Subscriber subscriber = new Subscriber(user.getUserId(), user.getUsername());
            userList.add(subscriber);
        }
    }

    @Data
    @AllArgsConstructor
    public static class Subscriber {
        private int userId;

        private String username;
    }
}
