'use client';

import { useState, useEffect, useRef } from 'react';
import { Button } from 'primereact/button';
import { Card } from 'primereact/card';
import { Image } from 'primereact/image';
//幻灯片
import { Carousel } from 'primereact/carousel';
//评分图标
import { Fire } from '@icon-park/react';
// 页面跳转
import { useRouter } from 'next/navigation';
import Link from 'next/link';
// 消息提醒
import { Toast } from 'primereact/toast';
// 接口传输
import axios from 'axios';
// 样式
import './community.scss';


// 热门社区信息
interface hotCommunity {
  communityId: number;
  communityName: string;
  hot: number;
  status: number; // 热门状态
  threadNumber: number;
  description: string;
  communityPicture: string;
  type: string;
}
interface Community {
  communityId: number;
  communityName: string;
  hot: number;
  threadNumber: number;
  description: string;
  communityPicture: string;
  type: string;
}


// 社区主页面
export default function CommunityPage() {
  // 路由
  const router = useRouter();
  // 消息提醒
  const toast = useRef<Toast>(null);
  // 热门社区数据
  const [hotCommunities, setHotCommunities] = useState<hotCommunity[]>([]);
  // 社区数据
  const [communities, setCommunities] = useState<Community[]>([]);
  // 获取热门社区信息
  useEffect(() => {
    const fetchHotCommunity = async () => {
      try {
        const { data } = await axios.get(process.env.PUBLIC_URL + `/community/hot`);
        setHotCommunities(data.communityList);
      } catch (err) {
        console.error(err);
        toast.current?.show({ severity: 'error', summary: 'error', detail: '获取热门社区失败' });
      }
    };
    fetchHotCommunity();
  }, []);

  // 获取社区信息
  useEffect(() => {
    const fetchCommunity = async () => {
      try {
        const { data } = await axios.get(process.env.PUBLIC_URL + `/community/common`);
        setCommunities(data.communityList);
        console.log(data.communityList);
      } catch (err) {
        console.error(err);
        toast.current?.show({ severity: 'error', summary: 'error', detail: '获取社区失败' });
      }
    };
    fetchCommunity();
  }, []);
  return (
    <div className="community-container">

      {/* 热门社区 */}
      <div className="hot-communities">
        <h1>热门社区</h1>
        <Carousel
          showIndicators={false}
          showNavigators={false}
          value={hotCommunities}
          numVisible={3}
          numScroll={1}
          className="hot-communities-carousel"
          itemTemplate={(item) => (
            <div className="hot-communities-card">
              <Card
                onClick={() => router.push(`/community/community-detail/${item.communityId}`)}
                title={item.communityName}
                header={
                  <div className="card-header">
                    <div className="card-tag">
                      <Image
                        src={`/images/${item.status}.svg`}
                        alt="热门标签"
                        width="24"
                        height="24"
                      /></div>
                    <Image src={item.communityPicture} alt={item.communityName} height="200" className="w-full h-48 object-cover" />
                  </div>
                }
              >
                <p>{item.description}</p>
              </Card>
            </div>
          )}
        />
      </div>

      {/* 全部分类 */}
      <h1>分类</h1>
      <div className="all-communities-classifications">
        <Link href="/community/resource-community-list/材质包">
          <Image
            className='communities-classification-card'
            src="/images/材质包.png"
            alt="Image"
            width="250"
          />
        </Link>
        <Link href="/community/resource-community-list/整合包">
          <Image
            className='communities-classification-card'
            src="/images/整合包.png"
            alt="Image"
            width="250"
          />
        </Link>
        <Link href="/community/resource-community-list/模组">
          <Image
            className='communities-classification-card'
            src="/images/模组.png"
            alt="Image"
            width="250"
          />
        </Link>
        <Link href="/community/resource-community-list/地图">
          <Image
            className='communities-classification-card'
            src="/images/地图.png"
            alt="Image"
            width="250"
          />
        </Link>
      </div>

      {/* 全部社区 */}
      <div className="all-communities">
        <div className="all-communities-header">
          <h1>全部社区</h1>
          <Link href="/community/resource-community-list/all">
            <Button label="查看更多" link />
          </Link>
        </div>
        <div className="all-communities-list">
          {communities.map((community) => (
            <Card key={community.communityId} className="all-communities-card" onClick={() => router.push(`/community/community-detail/${community.communityId}`)}>
              <Image alt="avatar" src={ community.communityPicture} className="community-avatar" width="250" height="140" />
              <div className="community-header">
                <div className="community-content">
                  <h3>{community.communityName}</h3>
                  <p className="community-introduction">{community.description}</p>
                </div>
                <div className="community-states">
                  <div className="state-item">
                    <Fire theme="outline" size="16" fill="#FF8D1A" />
                    <span>热度: {community.hot}</span>
                  </div>
                  <div className="state-item">
                    <i className="pi pi-book" />
                    <span>贴子数: {community.threadNumber}</span>
                  </div>
                </div>
              </div>
            </Card>
          ))}
        </div>
      </div>
    </div>
  );
}