// app/layout.tsx

import type { Metadata } from 'next';
// 页面跳转
import Link from 'next/link';
import UserAvatar from './user/component/userAvatar';
// PrimeReact 依赖
import { PrimeReactProvider } from 'primereact/api';
import 'primeicons/primeicons.css';
import 'primereact/resources/themes/lara-light-teal/theme.css'; // 主题
// 全局样式
import './globals.scss';

//设置标题
export const metadata: Metadata = {
  title: 'MCPT',
  description: 'MCPT resource Platform',
};

// 页首工具栏
export default function RootLayout({ children }: { children: React.ReactNode }) {
  return (
    <html lang="zh">
      <body>
        <PrimeReactProvider>
          <div className="container">
            <header className="toolbar">
              <div className="logo-name">
                <Link href="/" className="no-underline">
                  <img src="/logo.png" alt="Logo" className="logo" />

                </Link>
                <Link href="/" className="no-underline">
                  <span className="name">MCPT</span>
                </Link>

              </div>
              <div className="tools">
                <Link href="/resource/hot-resource" className="no-underline">
                  <div className="tool-item">
                    <i className="pi pi-trophy" />
                    <span>热门</span>
                  </div>
                </Link>
                <Link href="/search" className="no-underline">
                  <div className="tool-item">
                    <i className="pi pi-search" />
                    <span>搜索</span>
                  </div>
                </Link>

                <Link href="/community" className="no-underline">
                  <div className="tool-item">
                    <i className="pi pi-users" />
                    <span>社区</span>
                  </div>
                </Link>

                <Link href="/resource/classification" className="no-underline">
                  <div className="tool-item">
                    <i className="pi pi-tags" />
                    <span>分类</span>
                  </div>
                </Link>

                <Link href="/notification" className="no-underline">
                  <div className="tool-item">
                    <i className="pi pi-bell" />
                    <span>通知</span>
                  </div>
                </Link>
                <UserAvatar />
              </div>
            </header>
            <main className="mainContent">{children}</main>
          </div>
        </PrimeReactProvider>
      </body>
    </html>
  );
}
