package edu.bjtu.groupone.backend;

import edu.bjtu.groupone.backend.mapper.TorrentMapper;
import edu.bjtu.groupone.backend.mapper.UserMapper;
import edu.bjtu.groupone.backend.domain.entity.Torrent;
import edu.bjtu.groupone.backend.domain.entity.User;
import edu.bjtu.groupone.backend.service.impl.TorrentServiceImpl;
import java.io.File;
import java.io.FileInputStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.core.io.Resource;
import org.springframework.mock.web.MockMultipartFile;

@ExtendWith({MockitoExtension.class})
public class TorrentServiceImplTest {
    @Mock
    private TorrentMapper torrentMapper;
    @Mock
    private UserMapper userMapper;
    @InjectMocks
    private TorrentServiceImpl torrentService;

    public TorrentServiceImplTest() {
    }

    @BeforeEach
    void setup() {
    }

    @Test
    public void uploadTorrent_shouldSaveAndReturnTorrent() throws Exception {
        File file = new File("torrents/22301024-王玉涛.doc.torrent");
        Assertions.assertThat(file.exists()).isTrue();
        FileInputStream inputStream = new FileInputStream(file);
        MockMultipartFile mockFile = new MockMultipartFile("file", "22301024-王玉涛.doc.torrent", "application/x-bittorrent", inputStream);
        ((TorrentMapper)Mockito.doNothing().when(this.torrentMapper)).insertTorrent((Torrent)Mockito.any(Torrent.class));
        User fakeUser = new User();
        fakeUser.setUserId(100);
        Mockito.when(this.userMapper.selectById(100L)).thenReturn(fakeUser);
        Torrent result = this.torrentService.uploadTorrent(mockFile, 100L);
        Assertions.assertThat(result).isNotNull();
        Assertions.assertThat(result.getInfoHash()).isNotBlank();
        Assertions.assertThat(result.getName()).isNotBlank();
        Assertions.assertThat(result.getUploaderId()).isEqualTo(100L);
        ((TorrentMapper)Mockito.verify(this.torrentMapper, Mockito.times(1))).insertTorrent((Torrent)Mockito.any(Torrent.class));
    }

    @Test
    public void downloadTorrent_shouldReturnResource_whenTorrentExists() throws Exception {
        File tempFile = File.createTempFile("test-torrent-", ".torrent");
        tempFile.deleteOnExit();
        Torrent fakeTorrent = new Torrent();
        fakeTorrent.setInfoHash("fakeinfohash123");
        fakeTorrent.setFilePath(tempFile.getAbsolutePath());
        Mockito.when(this.torrentMapper.selectByInfoHash("fakeinfohash123")).thenReturn(fakeTorrent);
        Resource resource = this.torrentService.downloadTorrent("fakeinfohash123");
        Assertions.assertThat(resource).isNotNull();
        Assertions.assertThat(resource.exists()).isTrue();
        Assertions.assertThat(resource.getFile().getAbsolutePath()).isEqualTo(tempFile.getAbsolutePath());
    }
}
