package edu.bjtu.groupone.backend;

import edu.bjtu.groupone.backend.api.UserController;
import edu.bjtu.groupone.backend.domain.entity.Result;
import edu.bjtu.groupone.backend.domain.entity.User;
import edu.bjtu.groupone.backend.service.UserService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

import java.util.Arrays;
import java.util.List;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.*;

@ExtendWith(MockitoExtension.class)
class UserControllerTest {

    @Mock
    private UserService userService;

    @InjectMocks
    private UserController userController;

    private User testUser;

    @BeforeEach
    void setUp() {
        testUser = new User();
        testUser.setUserId(1);
        testUser.setUsername("testuser");
        testUser.setEmail("test@example.com");
    }

    @Test
    void deleteUser_shouldReturnSuccess() {
        // 调用
        Result<String> result = userController.deleteUser(1);

        // 验证：修改预期为英文 "success"
        assertEquals(0, result.getCode());
        assertEquals("success", result.getMsg());  // 修改这里
        verify(userService, times(1)).deleteUser(1);
    }

    @Test
    void updateUser_shouldReturnSuccess() {
        // 调用
        Result<String> result = userController.updateUser(1, testUser);

        // 验证：修改预期为英文 "success"
        assertEquals(0, result.getCode());
        assertEquals("success", result.getMsg());  // 修改这里
        verify(userService, times(1)).updateUser(any(User.class));
    }

    @Test
    void getUser_shouldReturnUser() {
        // 模拟
        when(userService.getUserById(1)).thenReturn(testUser);

        // 调用
        Result<User> result = userController.getUser(1);

        // 验证
        assertEquals(0, result.getCode());
        assertEquals(testUser, result.getData());
        verify(userService, times(1)).getUserById(1);
    }

    @Test
    void getAllUsers_shouldReturnUserList() {
        // 模拟
        List<User> users = Arrays.asList(testUser, new User());
        when(userService.getAllUsers()).thenReturn(users);

        // 调用
        Result<List<User>> result = userController.getAllUsers();

        // 验证
        assertEquals(0, result.getCode());
        assertEquals(2, result.getData().size());
        verify(userService, times(1)).getAllUsers();
    }
}