package edu.bjtu.groupone.backend;

import edu.bjtu.groupone.backend.domain.dto.WorkResponse;
import edu.bjtu.groupone.backend.domain.entity.Category;
import edu.bjtu.groupone.backend.domain.entity.Work;
import edu.bjtu.groupone.backend.mapper.WorkMybatisMapper;
import edu.bjtu.groupone.backend.service.CategoryService;
import edu.bjtu.groupone.backend.service.WorkService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.anyList;
import static org.mockito.Mockito.*;

@ExtendWith(MockitoExtension.class)
class WorkServiceTest {

    @Mock
    private WorkMybatisMapper mapper;

    @Mock
    private CategoryService categoryService;

    @InjectMocks
    private WorkService service;

    private Work testWork;
    private Category testCategory;

    @BeforeEach
    void setUp() {
        testCategory = new Category(1L, "Test Category", null);

        testWork = Work.builder()
                .id(1L)
                .title("Test Work")
                .author("Author")
                .views(100)
                .category(testCategory)
                .build();
    }

    @Test
    void addWork_shouldCallMapper() {
        // 调用
        service.addWork(testWork);

        // 验证
        verify(mapper, times(1)).save(testWork);
    }

    @Test
    void deleteWork_shouldCallMapper() {
        // 调用
        service.deleteWork(1L);

        // 验证
        verify(mapper, times(1)).deleteById(1L);
    }

    @Test
    void updateWork_shouldCallMapper() {
        // 调用
        service.updateWork(testWork);

        // 验证
        verify(mapper, times(1)).update(testWork);
    }

    @Test
    void getWorkById_shouldReturnWork() {
        // 模拟
        when(mapper.findById(1L)).thenReturn(testWork);

        // 调用
        Work result = service.getWorkById(1L);

        // 验证
        assertEquals(testWork, result);
        verify(mapper, times(1)).findById(1L);
    }

    @Test
    void getWorks_shouldReturnPage() {
        // 模拟
        Page<Work> workPage = new PageImpl<>(Collections.singletonList(testWork));
        when(categoryService.getAllSubcategoryIds(1L)).thenReturn(Arrays.asList(1L, 2L));
        when(mapper.findByCategoryIdIn(anyList(), any(Pageable.class))).thenReturn(workPage);

        // 调用
        Page<WorkResponse> result = service.getWorks(1L, 1, 10);

        // 验证
        assertEquals(1, result.getTotalElements());
        assertEquals("Test Work", result.getContent().get(0).getTitle());
        verify(mapper, times(1)).findByCategoryIdIn(anyList(), any(Pageable.class));
    }
}