package edu.bjtu.groupone.backend.api;

import edu.bjtu.groupone.backend.domain.entity.Comment;
import edu.bjtu.groupone.backend.domain.entity.Result;
import edu.bjtu.groupone.backend.service.CommentService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@CrossOrigin
@Tag(name = "评论相关接口")
@RestController
public class CommentController {

    @Autowired
    private CommentService commentService;

    @Operation(summary = "添加评论")
    @PostMapping("/comments")
    public Result<String> addComment(@RequestBody Comment comment) {
        commentService.addComment(comment);
        return Result.success("评论添加成功");
    }

    @Operation(summary = "删除评论")
    @DeleteMapping("/comments/{commentId}")
    public Result<String> deleteComment(@PathVariable Long commentId) {
        commentService.deleteComment(commentId);
        return Result.success("评论删除成功");
    }

    @Operation(summary = "更新评论")
    @PutMapping("/comments/{commentId}")
    public Result<String> updateComment(@PathVariable Long commentId, @RequestBody Comment comment) {
        comment.setCommentId(commentId);
        commentService.updateComment(comment);
        return Result.success("评论更新成功");
    }

    @Operation(summary = "获取评论详情")
    @GetMapping("/comments/{commentId}")
    public Result<Comment> getComment(@PathVariable Long commentId) {
        return Result.success(commentService.getCommentById(commentId));
    }

    @Operation(summary = "获取帖子所有评论")
    @GetMapping("/comments/post/{postId}")
    public Result<List<Comment>> getCommentsByPostId(@PathVariable Long postId) {
        return Result.success(commentService.getCommentsByPostId(postId));
    }
}