package edu.bjtu.groupone.backend.api;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.sql.DataSource;
import java.sql.Connection;

@RestController
@RequestMapping("/test")
public class DbTestController {

    @Autowired
    private DataSource dataSource;

    @GetMapping("/db")
    public String testDb() {
        try (Connection conn = dataSource.getConnection()) {
            return "✅ 成功连接数据库：" + conn.getMetaData().getURL();
        } catch (Exception e) {
            return "❌ 无法连接数据库：" + e.getMessage();
        }
    }
}