package edu.bjtu.groupone.backend.api;

import edu.bjtu.groupone.backend.domain.entity.Torrent;
import edu.bjtu.groupone.backend.service.TorrentService;
import edu.bjtu.groupone.backend.utils.GetTokenUserId;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@RestController
@RequestMapping("/api/torrents")
public class TorrentController {

    private final TorrentService torrentService;

    // 监听器列表应该放在专门的处理类中
    @Autowired
    public TorrentController(TorrentService torrentService) {
        this.torrentService = torrentService;
    }

    @PostMapping("/upload")
    public ResponseEntity<?> uploadTorrent(
            @RequestParam("file") MultipartFile file,
            @RequestParam("id") Long id ) throws Exception {

        Torrent saved = torrentService.uploadTorrent(file, id);
        return ResponseEntity.ok(saved);

    }
    @GetMapping("/download/{infoHash}")
    public ResponseEntity<Resource> downloadTorrent(@PathVariable String infoHash) {
        try {
            Resource resource = torrentService.downloadTorrent(infoHash);
            return ResponseEntity.ok()
                    .header("Content-Disposition", "attachment; filename=\"" + infoHash + ".torrent\"")
                    .body(resource);
        } catch (Exception ex) {
            return ResponseEntity.notFound().build();
        }
    }
    @PostMapping("/getTorrentList")
    public ResponseEntity<?> getTorrentList() throws Exception {

        List<Torrent> list = torrentService.getTorrentList();
        return ResponseEntity.ok(list);

    }

}