// PaginationConfig.java
package edu.bjtu.groupone.backend.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;

@Configuration
@Profile("!test")
public class PaginationConfig {
    @Bean
    public PageableHandlerMethodArgumentResolver pageableResolver() {
        PageableHandlerMethodArgumentResolver resolver = new PageableHandlerMethodArgumentResolver();
        resolver.setOneIndexedParameters(true); // 启用1-based页码
        resolver.setMaxPageSize(100);            // 限制最大每页数量
        return resolver;
    }
}