package edu.bjtu.groupone.backend.config;

import com.turn.ttorrent.tracker.TrackedPeer;
import com.turn.ttorrent.tracker.TrackedTorrent;
import com.turn.ttorrent.tracker.Tracker;
import edu.bjtu.groupone.backend.domain.entity.AnnounceEvent;
import edu.bjtu.groupone.backend.service.PeerTrafficService;

import java.io.IOException;
import java.net.InetSocketAddress;

public class TrafficAwareTracker extends Tracker {
    private final PeerTrafficService trafficService;

    public TrafficAwareTracker(InetSocketAddress address, PeerTrafficService trafficService)
            throws IOException {
        super(address);
        this.trafficService = trafficService;
    }

    public void peerAnnounce(TrackedTorrent torrent, TrackedPeer peer,
                             AnnounceEvent event) throws IOException {
        // 先记录流量（必须在super调用前执行）
        if (peer.getUploaded() > 0 || peer.getDownloaded() > 0) {
            trafficService.recordPeerTraffic(
                    torrent.getHexInfoHash(),
                    peer.getIp(),
                    peer.getPeerId(),
                    peer.getUploaded(),
                    peer.getDownloaded(),
                    System.currentTimeMillis() / 1000,
                    event
            );
        }
    }
}