package edu.bjtu.groupone.backend.domain.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
@Schema(description = "分区信息")
public class CategoryDTO {

    @Schema(description = "分区 ID", example = "1")
    private Long id;

    @Schema(description = "分区名称", example = "文学艺术")
    private String name;

    @Schema(description = "子分区")
    private List<CategoryDTO> children = new ArrayList<>();

    public CategoryDTO(Long id, String name) {
        this.id = id;
        this.name = name;
    }

    public CategoryDTO(Long id, String name, List<CategoryDTO> children) {
        this.id = id;
        this.name = name;
        this.children = children;
    }
}
