package edu.bjtu.groupone.backend.domain.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.*;

@Data
@Schema(description = "用户注册请求参数")
public class RegisterRequest {

    @NotNull(message = "用户名不能为空")
    @Size(min = 3, max = 20, message = "用户名长度必须在3到20个字符之间")
    @Schema(description = "用户名", required = true, example = "john_doe")
    private String username;

    @NotNull(message = "邮箱不能为空")
    @Email(message = "请输入有效的邮箱地址")
    @Schema(description = "用户邮箱", required = true, example = "john@example.com")
    private String email;

    @NotNull(message = "验证码不能为空")
    @Size(min = 6, max = 6, message = "验证码长度必须为6位")
    @Schema(description = "邮箱验证码", required = true, example = "123456")
    private String verificationCode;

    @NotNull(message = "密码不能为空")
    @Size(min = 6, message = "密码长度至少为6位")
    @Schema(description = "用户密码", required = true, example = "password123")
    private String password;

}    