package edu.bjtu.groupone.backend.domain.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Data
@Schema(description = "用户信息响应")
public class UserInfoResponse {

    @Schema(description = "用户名", example = "john_doe")
    private String username;

    @Schema(description = "JWT认证令牌", example = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9...")
    private String token;

    public UserInfoResponse(String username, String token) {
        this.username = username;
        this.token = token;
    }
}    