package edu.bjtu.groupone.backend.domain.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;

@Data
@AllArgsConstructor
@Schema(description = "作品信息")
public class WorkResponse {

    @Schema(description = "作品 ID", example = "101")
    private Long id;

    @Schema(description = "作品标题", example = "《我的世界》")
    private String title;

    @Schema(description = "作者", example = "张三")
    private String author;

    @Schema(description = "浏览量", example = "1234")
    private Integer views;

    @Schema(description = "所属分区 ID", example = "1")
    private Long categoryId;

    @Schema(description = "作品描述", example = "一部关于...")
    private String description;

    @Schema(description = "创建时间", example = "2023-06-15")
    private String createTime;
}
