//package edu.bjtu.groupone.backend.domain.entry;
//
//import lombok.AllArgsConstructor;
//import lombok.Data;
//import lombok.NoArgsConstructor;

//@Data
//@AllArgsConstructor
//@NoArgsConstructor
//public class Result {
//    private Integer code;//0表示成功，1表示失败
//    private String msg;//提示信息
//    private Object data;//要返回的数据
//    public static Result success() {//增删改响应成功
//
//        return new Result(0, "success", null);
//    }
//    public static Result success(Object data) {//增删改响应成功
//
//        return new Result(0, "success", data);
//    }
//    public static Result error(String msg) {//增删改响应成功
//
//        return new Result(1, msg, null);
//    }
//
//}

package edu.bjtu.groupone.backend.domain.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Schema(description = "通用响应结果")
public class Result<T> {
    @Schema(description = "状态码：0表示成功，1表示失败", example = "0")
    private Integer code;

    @Schema(description = "提示信息", example = "操作成功")
    private String msg;

    @Schema(description = "返回数据")
    private T data;

    public static <T> Result<T> success() {
        return new Result<>(0, "success", null);
    }

    public static <T> Result<T> success(T data) {
        return new Result<>(0, "success", data);
    }

    public static <T> Result<T> error(String msg) {
        return new Result<>(1, msg, null);
    }
}
