package edu.bjtu.groupone.backend.domain.entity;

import jakarta.persistence.*;
import lombok.*;

@Entity
@Table(name = "works")
@Data // 自动生成 getter/setter/toString
@NoArgsConstructor // JPA 必需的无参构造
@AllArgsConstructor // 全参构造
@Builder // 关键修复：添加 Builder 模式
public class Work {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(nullable = false, length = 255)
    private String title;

    @Column(nullable = false, length = 100)
    private String author;

    @Column(columnDefinition = "INT DEFAULT 0")
    private Integer views = 0;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(
            name = "category_id",
            foreignKey = @ForeignKey(name = "fk_work_category")
    )
    private Category category;
    @Column(columnDefinition = "TEXT")
    private String description;

    @Column(name = "create_time")
    private String createTime;
}