package edu.bjtu.groupone.backend.mapper;

import edu.bjtu.groupone.backend.domain.entity.Comment;
import org.apache.ibatis.annotations.*;

import java.util.List;

@Mapper
public interface CommentMapper {
    @Insert("INSERT INTO `comment` (`post_id`, `user_id`, `content`, `create_time`) VALUES (#{postId}, #{userId}, #{content}, #{createTime})")
    void insertComment(Comment comment);

    @Delete("DELETE FROM `comment` WHERE `comment_id` = #{commentId}")
    void deleteComment(Long commentId);

    @Update("UPDATE `comment` SET `post_id` = #{postId}, `user_id` = #{userId}, `content` = #{content}, `create_time` = #{createTime} WHERE `comment_id` = #{commentId}")
    void updateComment(Comment comment);

    @Select("SELECT * FROM `comment` WHERE `comment_id` = #{commentId}")
    Comment selectCommentById(Long commentId);

    @Select("SELECT * FROM `comment` WHERE `post_id` = #{postId}")
    List<Comment> selectCommentsByPostId(Long postId);
}