package edu.bjtu.groupone.backend.service;

//import edu.bjtu.groupone.backend.model.Work;
import edu.bjtu.groupone.backend.domain.dto.WorkResponse;
import edu.bjtu.groupone.backend.domain.entity.Work;
import edu.bjtu.groupone.backend.mapper.WorkMybatisMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
@Service
public class WorkService {
    @Autowired
    private WorkMybatisMapper workMybatisMapper;
    @Autowired
    private CategoryService categoryService;
    public Page<WorkResponse> getWorks(Long categoryId, int page, int size) {
        List<Long> categoryIds = categoryService.getAllSubcategoryIds(categoryId);
        Pageable pageable = PageRequest.of(page-1, size);
        return workMybatisMapper.findByCategoryIdIn(categoryIds, pageable)
                .map(this::convertToResponse);
    }
    private WorkResponse convertToResponse(Work work) {
        return new WorkResponse(
                work.getId(),
                work.getTitle(),
                work.getAuthor(),
                work.getViews(),
                work.getCategory().getId(),
                work.getDescription(),   // 新增字段
                work.getCreateTime()
        );
    }
    public void addWork(Work work) {
        work.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        workMybatisMapper.save(work);
    }
    public void deleteWork(Long id) {
        workMybatisMapper.deleteById(id);
    }
    public void updateWork(Work work) {
        Work existing = workMybatisMapper.findById(work.getId());
        if (existing != null) {
            work.setCreateTime(existing.getCreateTime());
        }
        workMybatisMapper.update(work);
    }
    public Work getWorkById(Long id) {
        return workMybatisMapper.findById(id);
    }
    public List<WorkResponse> getWorksByAuthor(String author) {
        List<Work> works = workMybatisMapper.findByAuthor(author);
        return works.stream()
                .map(this::convertToResponse)
                .collect(Collectors.toList());
    }
}