package edu.bjtu.groupone.backend.service.impl;

import edu.bjtu.groupone.backend.domain.entity.AnnounceEvent;
import edu.bjtu.groupone.backend.service.PeerTrafficService;
import org.springframework.stereotype.Service;

import java.nio.ByteBuffer;

@Service
public class PeerTrafficServiceImpl implements PeerTrafficService {
    @Override
    public void recordPeerTraffic(String infoHash, String ip, ByteBuffer peerId,
                                  long uploaded, long downloaded, long timestamp,
                                  AnnounceEvent customEvent) {
        // 在实现层转换peerId为String（如需）
        String peerIdStr = (peerId != null) ?
                new String(peerId.array()) : "unknown";

        // 实际存储逻辑...
        System.out.printf(
                "Traffic: %s | %s | %s | Up: %d | Down: %d | Event: %s%n",
                infoHash, ip, peerIdStr, uploaded, downloaded, customEvent
        );
    }
}