package edu.bjtu.groupone.backend.service.impl;

import edu.bjtu.groupone.backend.mapper.PostMapper;
import edu.bjtu.groupone.backend.domain.entity.Post;
import edu.bjtu.groupone.backend.service.PostService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class PostServiceImpl implements PostService {
    @Autowired
    private PostMapper postMapper;

    @Override
    public void addPost(Post post) {
        postMapper.insertPost(post);
    }

    @Override
    public void deletePost(Long postId) {
        postMapper.deletePost(postId);
    }

    @Override
    public void updatePost(Post post) {
        postMapper.updatePost(post);
    }

    @Override
    public Post getPostById(Long postId) {
        return postMapper.selectPostById(postId);
    }

    @Override
    public List<Post> getAllPosts() {
        return postMapper.selectAllPosts();
    }
}