package edu.bjtu.groupone.backend.service.impl;

import edu.bjtu.groupone.backend.mapper.TorrentMapper;
import edu.bjtu.groupone.backend.mapper.UserMapper;
import edu.bjtu.groupone.backend.domain.entity.Torrent;
import edu.bjtu.groupone.backend.domain.entity.User;
import edu.bjtu.groupone.backend.service.TorrentService;
import edu.bjtu.groupone.backend.utils.AliOSSUtils;
import edu.bjtu.groupone.backend.utils.TorrentParserUtil;
import java.io.File;
import java.util.List;
import java.util.Map;

import org.hibernate.sql.Alias;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TorrentServiceImpl implements TorrentService {
    @Value("${torrent.storage.path}")
    private String storagePath;
    @Autowired
    private TorrentMapper torrentMapper;
    @Autowired
    private UserMapper userMapper;

    @Autowired
    AliOSSUtils aliOSSUtils;

    public TorrentServiceImpl() {
    }

    public Torrent uploadTorrent(MultipartFile file, Long userId) throws Exception {
        Map<String, Object> meta = TorrentParserUtil.parseTorrent(file.getInputStream());
        String infoHash = (String)meta.get("infoHash");
        String name = (String)meta.get("name");
        Long size = (Long)meta.get("length");
        String pathToUse = this.storagePath != null && !this.storagePath.isBlank() ? this.storagePath : System.getProperty("java.io.tmpdir");
        File dir = new File(pathToUse);
        if (!dir.exists()) {
            dir.mkdirs();
        }

        String savePath = pathToUse + File.separator + infoHash + ".torrent";
        String upload = aliOSSUtils.upload(file);
        User uploader = this.userMapper.selectById(userId);
        Torrent torrent = new Torrent();
        torrent.setInfoHash(infoHash);
        torrent.setName(name);
        torrent.setFilePath(savePath);
        torrent.setSize(size);
        torrent.setUrl(upload);
        torrent.setUploaderId((long)uploader.getUserId());
        this.torrentMapper.insertTorrent(torrent);
        return torrent;
    }

    public Resource downloadTorrent(String infoHash) throws Exception {
        Torrent torrent = this.torrentMapper.selectByInfoHash(infoHash);
        if (torrent == null) {
            throw new IllegalArgumentException("种子不存在");
        } else {
            File file = new File(torrent.getFilePath());
            if (!file.exists()) {
                throw new IllegalStateException("种子文件不存在");
            } else {
                return new FileSystemResource(file);
            }
        }
    }

    @Override
    public List<Torrent> getTorrentList() {
        return torrentMapper.getTorrentList();
    }
}
