package edu.bjtu.groupone.backend.utils;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class EmailUtil {
    @Autowired
    private JavaMailSender mailSender;

    @Value("${spring.mail.username}") // 确保从配置读取
    private String from; 

    public void sendVerificationEmail(String to, String code) {
        try {
            MimeMessage message = mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message);
            
            // 关键修改：使用配置的授权邮箱作为发件人
            helper.setFrom(from); 
            helper.setTo(to);
            helper.setSubject("[PT SITE] 验证码通知");
            helper.setText("您的验证码是：" + code + "，5分钟内有效");
            
            mailSender.send(message);
            log.info("邮件发送成功：{}", to);
        } catch (MessagingException e) {
            log.error("邮件发送失败", e);
            throw new RuntimeException("邮件服务异常");
        }
    }
}
