package edu.bjtu.groupone.backend.utils;

import edu.bjtu.groupone.backend.domain.dto.CategoryDTO;
import edu.bjtu.groupone.backend.domain.entity.Category;
//import edu.bjtu.groupone.backend.model.Category;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TreeBuilder {
    public static List<CategoryDTO> buildTree(List<Category> allCategories) {
        // 使用明确的类型声明
        Map<Long, CategoryDTO> dtoMap = allCategories.stream()
                .map(c -> new CategoryDTO(c.getId(), c.getName()))
                .collect(Collectors.toMap(
                        CategoryDTO::getId,
                        dto -> dto,
                        (existing, replacement) -> existing
                ));

        List<CategoryDTO> result = new ArrayList<>();
        allCategories.forEach(c -> {
            CategoryDTO dto = dtoMap.get(c.getId());
            if (c.getParent() == null) {
                result.add(dto);
            } else {
                CategoryDTO parentDto = dtoMap.get(c.getParent().getId());
                parentDto.getChildren().add(dto);
            }
        });
        return result;
    }
}