package edu.bjtu.groupone.backend;

import edu.bjtu.groupone.backend.domain.entity.Comment;
import edu.bjtu.groupone.backend.mapper.CommentMapper;
import edu.bjtu.groupone.backend.service.impl.CommentServiceImpl;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

import java.util.Arrays;
import java.util.List;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.mockito.Mockito.*;

@ExtendWith(MockitoExtension.class)
public class CommentServiceTest {

    @Mock
    private CommentMapper commentMapper;

    @InjectMocks
    private CommentServiceImpl commentService;

    private Comment comment;
    private List<Comment> comments;

    @BeforeEach
    void setUp() {
        comment = new Comment(1L, 1L, 1, "测试评论", "2023-06-15");
        comments = Arrays.asList(comment);
    }

    @Test
    void addComment() {
        doNothing().when(commentMapper).insertComment(any(Comment.class));

        commentService.addComment(comment);

        verify(commentMapper, times(1)).insertComment(comment);
    }

    @Test
    void deleteComment() {
        doNothing().when(commentMapper).deleteComment(1L);

        commentService.deleteComment(1L);

        verify(commentMapper, times(1)).deleteComment(1L);
    }

    @Test
    void updateComment() {
        doNothing().when(commentMapper).updateComment(any(Comment.class));

        commentService.updateComment(comment);

        verify(commentMapper, times(1)).updateComment(comment);
    }

    @Test
    void getCommentById() {
        when(commentMapper.selectCommentById(1L)).thenReturn(comment);

        Comment result = commentService.getCommentById(1L);

        assertEquals(comment, result);
    }

    @Test
    void getCommentsByPostId() {
        when(commentMapper.selectCommentsByPostId(1L)).thenReturn(comments);

        List<Comment> result = commentService.getCommentsByPostId(1L);

        assertEquals(comments, result);
    }
}