package edu.bjtu.groupone.backend;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

import javax.sql.DataSource;
import java.sql.Connection;

import static org.junit.jupiter.api.Assertions.*;

@SpringBootTest
public class DatabaseConnectionTest {

    @Autowired
    private DataSource dataSource;

    @Test
    public void testDatabaseConnection() {
        try (Connection connection = dataSource.getConnection()) {
            assertNotNull(connection);
            System.out.println("✅ 数据库连接成功: " + connection.getMetaData().getURL());
            System.out.println("📌 数据库用户: " + connection.getMetaData().getUserName());
        } catch (Exception e) {
            fail("❌ 数据库连接失败: " + e.getMessage());
        }
    }
}
