package edu.bjtu.groupone.backend.mapper;


import edu.bjtu.groupone.backend.model.User;
import org.apache.ibatis.annotations.*;

@Mapper
public interface UserMapper {
     @Select("select * from user where email=#{email} and password=#{password}")
     User login(User user);

     @Select("SELECT * FROM user WHERE username = #{username}")
    User selectByUsername(String username);

    @Select("SELECT * FROM user WHERE email = #{email}")
    User selectByEmail(String email);

    @Insert("INSERT INTO user(username, email, password, registration_date, identification_number) " +
            "VALUES(#{username}, #{email}, #{password}, #{registrationDate}, #{identificationNumber})")
    @Options(useGeneratedKeys = true, keyProperty = "userId")
    void insertUser(User user);

    @Update("UPDATE `user` SET password = #{password} WHERE email = #{email}")
    int updatePasswordByEmail(@Param("email") String email,
                              @Param("password") String password);

    @Select("SELECT COUNT(*) FROM user WHERE identification_number = #{identificationNumber}")
    int countByIdentificationNumber(int identificationNumber);
}
