package edu.bjtu.groupone.backend;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import java.time.LocalDateTime;

import ch.qos.logback.classic.Logger;
import org.slf4j.LoggerFactory;
import edu.bjtu.groupone.backend.mapper.UserMapper;
import edu.bjtu.groupone.backend.model.User;
import edu.bjtu.groupone.backend.service.impl.UserServImpl;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(MockitoExtension.class)
public class UserControllerTest {

    // 初始化 Logger，避免空指针
    private static final Logger log = (Logger) LoggerFactory.getLogger(UserControllerTest.class);

    @Mock
    private UserMapper userMapper;



    @InjectMocks
    private UserServImpl userService;



    @Test
    public void testLogin() {
        User loginUser = new User();
        loginUser.setIdentificationNumber(123456);
        loginUser.setPassword("password123");
        User expected = new User();
        expected.setUsername("expectedUsername");

        // 模拟 mapper 返回
        when(userMapper.login(loginUser)).thenReturn(expected);

        // 调用 service 并断言
        User result = userService.login(loginUser);
        assertThat(result).isNotNull();
        assertThat(result.getUsername()).isEqualTo("expectedUsername");
        verify(userMapper, times(1)).login(loginUser);
    }


}
