package edu.bjtu.groupone.backend.mapper;

import edu.bjtu.groupone.backend.domain.entity.Category;
import org.apache.ibatis.annotations.*;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface CategoryMybatisMapper {
    List<Category> findByParentId(Long parentId);
    List<Category> findAll();
    // 新增
    @Insert("INSERT INTO categories(name, parent_id) VALUES(#{name}, #{parent.id,jdbcType=BIGINT})")
    @Options(useGeneratedKeys = true, keyProperty = "id")
    void insert(Category category);

    // 删除
    @Delete("DELETE FROM categories WHERE id = #{id}")
    void deleteById(Long id);

    // 更新
    @Update("UPDATE categories SET name=#{name}, parent_id=#{parent.id,jdbcType=BIGINT} WHERE id=#{id}")
    void update(Category category);

    // 查询
    @Select("SELECT * FROM categories WHERE id = #{id}")
    Category findById(Long id);
}
