package edu.bjtu.groupone.backend.mapper;

import edu.bjtu.groupone.backend.domain.entity.Post;
import org.apache.ibatis.annotations.*;

import java.util.List;

@Mapper
public interface PostMapper {
    @Insert("INSERT INTO `post` (`user_id`, `title`, `content`, `create_time`, `views`) VALUES (#{userId}, #{title}, #{content}, #{createTime}, #{views})")
    void insertPost(Post post);

    @Delete("DELETE FROM `post` WHERE `post_id` = #{postId}")
    void deletePost(Long postId);

    @Update("UPDATE `post` SET `user_id` = #{userId}, `title` = #{title}, `content` = #{content}, `create_time` = #{createTime}, `views` = #{views} WHERE `post_id` = #{postId}")
    void updatePost(Post post);

    @Select("SELECT * FROM `post` WHERE `post_id` = #{postId}")
    Post selectPostById(Long postId);

    @Select("SELECT * FROM `post`")
    List<Post> selectAllPosts();
}