package edu.bjtu.groupone.backend.mapper;

import edu.bjtu.groupone.backend.domain.entity.Torrent;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

@Mapper
public interface TorrentMapper {

    @Insert("INSERT INTO torrents (name, info_hash, size, uploader_id, url) " +
            "VALUES (#{name}, #{infoHash}, #{size}, #{uploaderId}, #{url})")
    void insertTorrent(Torrent torrent);

    @Select("SELECT * FROM torrents WHERE info_hash = #{infoHash}")
    Torrent selectByInfoHash(@Param("infoHash") String infoHash);

    @Delete("DELETE FROM torrents WHERE info_hash = #{infoHash}")
    void deleteByInfoHash(@Param("infoHash") String infoHash);

    @Select("SELECT * FROM torrents")
    List<Torrent> getTorrentList();

}
