package edu.bjtu.groupone.backend.mapper;

import edu.bjtu.groupone.backend.domain.UserRole;
import org.apache.ibatis.annotations.*;

import java.util.List;

@Mapper
public interface UserRoleMapper {
    @Select("SELECT * FROM user_role WHERE user_id = #{userId}")
    List<UserRole> getUserRolesByUserId(Long userId);

    @Insert("INSERT INTO user_role (user_id, role, create_time) VALUES (#{userId}, #{role}, NOW())")
    @Options(useGeneratedKeys = true, keyProperty = "id")
    int insertUserRole(UserRole userRole);
} 