// edu.bjtu.groupone.backend.mapper.WorkMapper

package edu.bjtu.groupone.backend.mapper;

import edu.bjtu.groupone.backend.domain.entity.Work;
import edu.bjtu.groupone.backend.domain.entity.Version;
import edu.bjtu.groupone.backend.domain.entity.Comment;
import org.apache.ibatis.annotations.*;

import java.util.List;
import java.util.Map;

@Mapper
public interface WorkMapper {
    @Select("SELECT * FROM works WHERE user_id = #{userId} AND status = 'UPLOADING'")
    List<Work> getUncompletedWorksByUserId(@Param("userId") Long userId);

    @Select("SELECT * FROM works WHERE user_id = #{userId} AND status = 'COMPLETED'")
    List<Work> getCompletedWorksByUserId(@Param("userId") Long userId);

    @Select("SELECT * FROM works WHERE id = #{id}")
    Work getWorkById(@Param("id") Long id);

    @Insert("INSERT INTO works " +
            "(title, description, user_id, status, category_id, create_time, update_time) " +
            "VALUES " +
            "(#{title}, #{description}, #{userId}, #{status}, #{category.id}, NOW(), NOW())")
    @Options(useGeneratedKeys = true, keyProperty = "id")
    int insertWork(Work work);

    @Update("UPDATE works SET " +
            "title       = #{title}, " +
            "description = #{description}, " +
            "status      = #{status}, " +
            "category_id = #{category.id}, " +
            "update_time = NOW() " +
            "WHERE id    = #{id}")
    int updateWork(Work work);

    @Delete("DELETE FROM works WHERE id = #{id}")
    int deleteWork(@Param("id") Long id);

    @Insert("INSERT INTO version (work_id, version_number, file_url, description, create_time) " +
            "VALUES (#{workId}, #{versionNumber}, #{fileUrl}, #{description}, NOW())")
    @Options(useGeneratedKeys = true, keyProperty = "id")
    int insertVersion(Version version);

    @Delete("DELETE FROM version WHERE id = #{id}")
    int deleteVersion(@Param("id") Long id);

    @Insert("INSERT INTO comment (work_id, user_id, content, create_time) " +
            "VALUES (#{workId}, #{userId}, #{content}, NOW())")
    @Options(useGeneratedKeys = true, keyProperty = "id")
    int insertComment(Comment comment);

    @Delete("DELETE FROM comment WHERE id = #{id}")
    int deleteComment(@Param("id") Long id);

    @Select("SELECT content FROM comment WHERE work_id = #{workId}")
    List<String> getCommentsByWorkId(@Param("workId") Long workId);

    @Select("SELECT version_number, file_url, description FROM version WHERE work_id = #{workId}")
    List<Map<String, Object>> getVersionsByWorkId(@Param("workId") Long workId);

    @Select("SELECT u.username, u.user_id FROM seeding_user su " +
            "JOIN user u ON su.user_id = u.user_id " +
            "WHERE su.work_id = #{workId} AND su.status = 'seeding'")
    List<Map<String, Object>> getSeedingUsersByWorkId(@Param("workId") Long workId);

    @Select("SELECT u.username, u.user_id, su.uploaded FROM seeding_user su " +
            "JOIN user u ON su.user_id = u.user_id " +
            "WHERE su.work_id = #{workId} AND su.status = 'history'")
    List<Map<String, Object>> getHistorySeedingUsersByWorkId(@Param("workId") Long workId);
}
