package edu.bjtu.groupone.backend.api;

import edu.bjtu.groupone.backend.domain.dto.CategoryDTO;
import edu.bjtu.groupone.backend.domain.entity.Category;
import edu.bjtu.groupone.backend.service.CategoryService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/categories")
@Tag(name = "Category", description = "分区相关接口")
public class CategoryController {

    @Autowired
    private CategoryService categoryService;

    @GetMapping
    @Operation(summary = "获取所有分区（树形结构）", description = "返回所有分区及其子分区")
    public ResponseEntity<List<CategoryDTO>> getCategories() {
        return ResponseEntity.ok(categoryService.getCategoryTree());
    }
    // 创建分区
    @PostMapping
    @Operation(summary = "创建新分区")
    public ResponseEntity<String> createCategory(@RequestBody Category category) {
        categoryService.addCategory(category);
        return ResponseEntity.ok("分区创建成功");
    }

    // 删除分区
    @DeleteMapping("/{id}")
    @Operation(summary = "删除分区")
    public ResponseEntity<String> deleteCategory(@PathVariable Long id) {
        categoryService.deleteCategory(id);
        return ResponseEntity.ok("分区删除成功");
    }

    // 更新分区
    @PutMapping("/{id}")
    @Operation(summary = "更新分区信息")
    public ResponseEntity<String> updateCategory(@PathVariable Long id, @RequestBody Category category) {
        category.setId(id);
        categoryService.updateCategory(category);
        return ResponseEntity.ok("分区更新成功");
    }

    // 获取单个分区
    @GetMapping("/{id}")
    @Operation(summary = "获取分区详情")
    public ResponseEntity<Category> getCategory(@PathVariable Long id) {
        return ResponseEntity.ok(categoryService.getCategoryById(id));
    }
}
