package edu.bjtu.groupone.backend.api;

import edu.bjtu.groupone.backend.domain.entity.Torrent;
import edu.bjtu.groupone.backend.service.TorrentService;
import edu.bjtu.groupone.backend.utils.GetTokenUserId;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping({"/api/torrents"})
public class TorrentController {
    @Autowired
    private TorrentService torrentService;

    public TorrentController() {
    }

    @PostMapping({"/upload"})
    public ResponseEntity<?> uploadTorrent(@RequestParam("file") MultipartFile file, HttpServletRequest request) {
        String uidStr = GetTokenUserId.getUserId(request);
        if (uidStr == null) {
            return ResponseEntity.status(HttpStatus.UNAUTHORIZED).body("Token无效或缺失");
        } else {
            try {
                Long userId = Long.parseLong(uidStr);
                Torrent saved = this.torrentService.uploadTorrent(file, userId);
                return ResponseEntity.ok(saved);
            } catch (Exception var6) {
                return ResponseEntity.status(HttpStatus.BAD_REQUEST).body("上传失败：" + var6.getMessage());
            }
        }
    }

    @GetMapping({"/download/{infoHash}"})
    public ResponseEntity<Resource> downloadTorrent(@PathVariable String infoHash) {
        try {
            Resource resource = this.torrentService.downloadTorrent(infoHash);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + infoHash + ".torrent\""})).body(resource);
        } catch (Exception var3) {
            return ResponseEntity.notFound().build();
        }
    }
}
