// src/main/java/edu/bjtu/groupone/backend/config/Config.java
package edu.bjtu.groupone.backend.config;

import edu.bjtu.groupone.backend.interceptor.Interceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.*;

@Configuration
public class Config implements WebMvcConfigurer {

    @Autowired
    private Interceptor authInterceptor;

    /** 全局 CORS 配置 */
    @Override
    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**")
                // Vite 默认端口 5173，如果你的 React 在 3000 也一并写上
                .allowedOrigins("http://localhost:5173", "http://localhost:3000")
                .allowedMethods("GET", "POST", "PUT", "DELETE", "OPTIONS")
                .allowedHeaders("*")
                // 如果需要前端带 Cookie（如 JWT 存在 Cookie）就打开
                .allowCredentials(true)
                .maxAge(3600);
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(authInterceptor)
                .addPathPatterns("/**")
                .excludePathPatterns(
                        // 放行 swagger-ui 的所有静态资源和 API 文档
                        "/swagger-ui/**",
                        "/swagger-ui.html",
                        "/v3/api-docs/**",
                        "/favicon.ico"
                );
    }
    // 其它 CORS、静态资源、Swagger 配置保持不动
}
