package edu.bjtu.groupone.backend.config;

import com.turn.ttorrent.tracker.TrackedTorrent;
import com.turn.ttorrent.tracker.Tracker;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class TrackerStarter {
    private Tracker tracker;

    public TrackerStarter() {
    }

    @PostConstruct
    public void startTracker() throws Exception {
        InetSocketAddress address = new InetSocketAddress("0.0.0.0", 6969);
        this.tracker = new Tracker(address);
        this.tracker.start();
        System.out.println("Tracker started on http://localhost:6969/announce");
    }

    @Scheduled(
            fixedRate = 60000L
    )
    public void scanTorrentDirectory() throws IOException, NoSuchAlgorithmException {
        File torrentDir = new File("C:\\Users\\wangy\\Desktop\\GroupOne-Back-End(2)\\GroupOne-Back-End\\torrents");
        if (torrentDir.exists() && torrentDir.isDirectory()) {
            File[] var2 = (File[])Objects.requireNonNull(torrentDir.listFiles());
            int var3 = var2.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                File file = var2[var4];
                if (file.getName().endsWith(".torrent")) {
                    this.tracker.announce(TrackedTorrent.load(file));
                    System.out.println("Loaded torrent: " + file.getName());
                }
            }
        } else {
            System.out.println("Torrent directory not found: " + torrentDir.getAbsolutePath());
        }

    }
}
