// src/main/java/edu/bjtu/groupone/backend/interceptor/Interceptor.java
package edu.bjtu.groupone.backend.interceptor;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.bjtu.groupone.backend.domain.entity.Result;
import edu.bjtu.groupone.backend.utils.JwtUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;

@Slf4j
@Component
public class Interceptor implements HandlerInterceptor {

    
    @Override
    public boolean preHandle(HttpServletRequest req,
                             HttpServletResponse resp,
                             Object handler) throws Exception {
        String url = req.getRequestURI();
        log.info("Request URI: {}", url);
        // 放行无需鉴权的路径：登录、注册、发码、静态资源、HTML 页面
        if (url.contains("sendResetCode") ||  // 发送重置验证码
                url.contains("resetPassword") ||
                url.equals("/") ||
                url.endsWith(".html") ||
                url.contains("login") ||
                url.contains("register") ||
                url.equals("/api/me") ||      // 放行用户信息接口
                url.equals("/error") ||       // 放行错误页面
                url.contains("sendVerification") ||
                url.startsWith("/swagger-ui/") ||
                url.startsWith("/v3/api-docs/") ||
                url.startsWith("/favicon.ico") ||
                url.startsWith("/static/")) {
            return true;
        }
        // 从请求头读取 token
        String token = req.getHeader("token");
        if (!StringUtils.hasLength(token)) {
            resp.setContentType("application/json;charset=UTF-8");
            resp.getWriter()
                    .write(new ObjectMapper()
                            .writeValueAsString(Result.error("NOT_LOGIN")));
            return false;
        }
        try {
            JwtUtils.parseJwt(token);
            return true;
        } catch (Exception e) {
            resp.setContentType("application/json;charset=UTF-8");
            resp.getWriter()
                    .write(new ObjectMapper()
                            .writeValueAsString(Result.error("NOT_LOGIN")));
            return false;
        }
    }

}
